//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;

namespace DelegatesAndEvents
{
	/// <summary>
	/// Podsumowanie dla Class1.
	/// </summary>
	class HelloWorld
	{
		static private void HelloWorldProcessor(string message)
		{
			Console.WriteLine(message);
		}
		public delegate void HelloWorldDelegate(string message);
		static void Main(string[] args)
		{
			HelloWorldDelegate d = new HelloWorldDelegate(HelloWorldProcessor);
			d.DynamicInvoke(new object[] { "Witaj" });
			d.DynamicInvoke(new object[] { "wiecie!" });

			// or

			d("Witaj wiecie!");

			// or 
			d += new HelloWorldDelegate(HelloWorldProcessor);
			d += new HelloWorldDelegate(HelloWorldProcessor);
			d += new HelloWorldDelegate(HelloWorldProcessor);
			d += new HelloWorldDelegate(HelloWorldProcessor);
			d += new HelloWorldDelegate(HelloWorldProcessor);

			d("Witaj wiecie! (wiele razy)");

		}
	}
}
